// File created 10/21/2005 12:46:06
unit CoreClassesUnit;

interface

uses
  System.Collections,
  Borland.Eco.Services,
  Borland.Eco.UmlRt,
  Borland.Eco.UmlCodeAttributes,
  Borland.Eco.ObjectImplementation,
  Borland.Eco.ObjectRepresentation, Borland.Eco.Subscription;
type
  Meeting = class;
  Group = class;
  Person = class;
  Participancy = class;
  Resource = class;
  Participant = class;
  
  [UmlElement('Package', Id='a1e1829e-473d-4961-8d36-53c94fa17e6f')]
  [UmlMetaAttribute('ownedElement', TypeOf(Meeting))]
  [UmlMetaAttribute('ownedElement', TypeOf(Group))]
  [UmlMetaAttribute('ownedElement', TypeOf(Person))]
  [UmlMetaAttribute('ownedElement', TypeOf(Participancy))]
  [UmlMetaAttribute('ownedElement', TypeOf(Resource))]
  [UmlMetaAttribute('ownedElement', TypeOf(Participant))]
  [EcoCodeGenVersion('2.0')]
  CoreClasses = class
  public
  type
    [UmlElement('Association', Id='41d87212-063e-4665-a45a-adb2b52bad7a')]
    Participancy = class
    end;
    
    [UmlElement('Association', Id='4fdb3424-99c8-46a7-80cd-5bf995d0fd83')]
    Membership = class
    end;
    
    [UmlElement('Association', Id='001b5e20-5aca-4199-b126-caf9dac34923')]
  [UmlTaggedValue('persistence', 'transient')]
  [UmlTaggedValue('derived', 'true')]
    DerivedAssociation = class
    public
    type
      
   

      [UmlElement('AssociationEnd', Id='5d891504-182c-4f1b-9991-2fd36b8ed5a5')]
      [UmlMetaAttribute('multiplicity', '0..*')]
      [UmlMetaAttribute('association', TypeOf(CoreClasses.DerivedAssociation), Index=1)]
      meeting = class
      end; end;
    
    [UmlElement('Association', Id='43699795-da6c-42f5-81f8-526690ada29b')]
    Ownership = class
    end;
    
  end;
  IResourceList = interface;
  [UmlCollection(TypeOf(Resource))]
  IResourceList = interface(ICollection)
    {$REGION 'ECO generated code'}
    function get_Item(index: Integer): Resource;
    procedure set_Item(index: Integer; Value: Resource);
    property Item[index: Integer]: Resource read get_Item write set_Item; default;
    function Add(value: Resource): Integer;
    function Contains(value: Resource): Boolean;
    function IndexOf(value: Resource): Integer;
    procedure Insert(index: Integer; value: Resource);
    procedure Remove(value: Resource);
    procedure Clear;
    procedure RemoveAt(index: Integer);
    {$ENDREGION 'ECO generated code'}
  end;
  IPersonList = interface;
  [UmlCollection(TypeOf(Person))]
  IPersonList = interface(ICollection)
    {$REGION 'ECO generated code'}
    function get_Item(index: Integer): Person;
    procedure set_Item(index: Integer; Value: Person);
    property Item[index: Integer]: Person read get_Item write set_Item; default;
    function Add(value: Person): Integer;
    function Contains(value: Person): Boolean;
    function IndexOf(value: Person): Integer;
    procedure Insert(index: Integer; value: Person);
    procedure Remove(value: Person);
    procedure Clear;
    procedure RemoveAt(index: Integer);
    {$ENDREGION 'ECO generated code'}
  end;
  IMeetingList = interface;
  IParticipantList = interface;
  IParticipancyList = interface;
  [UmlCollection(TypeOf(Meeting))]
  IMeetingList = interface(ICollection)
    {$REGION 'ECO generated code'}
    function get_Item(index: Integer): Meeting;
    procedure set_Item(index: Integer; Value: Meeting);
    property Item[index: Integer]: Meeting read get_Item write set_Item; default;
    function Add(value: Meeting): Integer;
    function Contains(value: Meeting): Boolean;
    function IndexOf(value: Meeting): Integer;
    procedure Insert(index: Integer; value: Meeting);
    procedure Remove(value: Meeting);
    procedure Clear;
    procedure RemoveAt(index: Integer);
    {$ENDREGION 'ECO generated code'}
  end;
  
  [UmlElement(Id='5138d8e0-2381-42df-9f32-54724c950d23')]
  [UmlMetaAttribute('constraint', 'Meeting need at least one participant=par' +
  'ticipants->size > 0')]
  Meeting = class(System.Object, ILoopBack)
    {$REGION 'ECO generated code'}
  public
  type
    Eco_LoopbackIndices = class
    public
    const
      Eco_FirstMember = 0;
    const
      Eco_MemberCount = (Eco_FirstMember + 7);
    const
      EndTime = Eco_FirstMember;
    const
      Duration = (Eco_LoopbackIndices.EndTime + 1);
    const
      Subject = (Eco_LoopbackIndices.Duration + 1);
    const
      Time = (Eco_LoopbackIndices.Subject + 1);
    const
      participants = (Eco_LoopbackIndices.Time + 1);
    const
      Participancy = (Eco_LoopbackIndices.participants + 1);
    const
      confirmedParticipants = (Eco_LoopbackIndices.Participancy + 1);
    end;

    MeetingListAdapter = class(ObjectListAdapter, IMeetingList)
    public
      constructor Create(source: IList);
      function get_Item(index: Integer): Meeting;
      procedure set_Item(index: Integer; Value: Meeting);
      property Item[index: Integer]: Meeting read get_Item write set_Item; default;
      function Add(value: Meeting): Integer;
      function Contains(value: Meeting): Boolean;
      function IndexOf(value: Meeting): Integer;
      procedure Insert(index: Integer; value: Meeting);
      procedure Remove(value: Meeting);
    end;
    
  strict protected
    eco_Content: IContent;
  strict private
    function IObjectProvider.AsIObject = IObjectProvider_AsIObject;
    function IObjectProvider_AsIObject: IObject;
  public
    function AsIObject: IObjectInstance;
    procedure set_MemberByIndex(index: Integer; value: System.Object); virtual;
    function get_MemberByIndex(index: Integer): System.Object; virtual;
  strict protected
    procedure Deinitialize(serviceProvider: IEcoServiceProvider);
    procedure Initialize(serviceProvider: IEcoServiceProvider);
  public
    constructor Create(content: IContent); overload;
    {$ENDREGION 'ECO generated code'}
    constructor Create(serviceProvider: IEcoServiceProvider); overload;
    function get_EndTime: System.DateTime;
    [UmlElement(Id='0418b1d7-99a3-4005-82a5-c812a9d8d63d', Index=Eco_LoopbackIndices.EndTime)]
    [UmlTaggedValue('persistence', 'transient')]
    [UmlTaggedValue('derived', 'true')]
    property EndTime: System.DateTime read get_EndTime;
    function get_Duration: Integer;
    procedure set_Duration(Value: Integer);
    [UmlElement(Id='0caf47c8-cee4-44aa-af82-6f4f315b206e', Index=Eco_LoopbackIndices.Duration)]
    property Duration: Integer read get_Duration write set_Duration;
    function get_Subject: string;
    procedure set_Subject(Value: string);
    [UmlElement(Id='3750d3c7-aa71-4ab0-98da-2a92213fbc65', Index=Eco_LoopbackIndices.Subject)]
    property Subject: string read get_Subject write set_Subject;
    function get_Time: System.DateTime;
    procedure set_Time(Value: System.DateTime);
    [UmlElement(Id='6d7ae99c-da15-4f90-98c5-bbc0c768d52c', Index=Eco_LoopbackIndices.Time)]
    [UmlTaggedValue('Eco.ColumnName', '<Name>Column')]
    property Time: System.DateTime read get_Time write set_Time;
    function get_participants: IParticipantList;
    [UmlElement('AssociationEnd', Index=Eco_LoopbackIndices.participants, Id='22b' +
    '26c13-be6e-4951-a135-495440bd5b84')]
    [UmlMetaAttribute('association', TypeOf(CoreClasses.Participancy), Index=1)]
    [UmlMetaAttribute('multiplicity', '0..*')]
    property participants: IParticipantList read get_participants;
    function get_Participancy: IParticipancyList;
    [LinkRole('22b26c13-be6e-4951-a135-495440bd5b84')]
    property Participancy: IParticipancyList read get_Participancy;
    function get_confirmedParticipants: IParticipantList;
    [UmlElement('AssociationEnd', Index=Eco_LoopbackIndices.confirmedParticipants, Id='2' +
    'aae25bd-0d4a-4ed0-aa53-6f88fd74ada9')]
    [UmlMetaAttribute('association', TypeOf(CoreClasses.DerivedAssociation), Index=0)]
    [UmlMetaAttribute('multiplicity', '0..*')]
    [UmlTaggedValue('Eco.DerivationOCL', ('self.Participancy->select(confirm' +
    'e' + 'd).participants'))]
    property confirmedParticipants: IParticipantList read get_confirmedParticipants;
    [UmlElement(Id='0c55f0b2-0918-412c-9bc8-9467ff9d6590')]
    procedure CancelMeeting;
    [UmlElement(Id='1e65284a-2230-4295-91d6-880a8025a69a')]
    procedure RemindParticipants;
    [UmlElement(Id='92630913-37af-4ae9-94fa-2096a924f666')]
    function EndTimeDeriveAndSubscribe(ReevaluateSubscriber: Borland.Eco.Subscription.ISubscriber; 
      ResubscribeSubscriber: Borland.Eco.Subscription.ISubscriber): System.Object;
  end;
  IGroupList = interface;
  [UmlCollection(TypeOf(Group))]
  IGroupList = interface(ICollection)
    {$REGION 'ECO generated code'}
    function get_Item(index: Integer): Group;
    procedure set_Item(index: Integer; Value: Group);
    property Item[index: Integer]: Group read get_Item write set_Item; default;
    function Add(value: Group): Integer;
    function Contains(value: Group): Boolean;
    function IndexOf(value: Group): Integer;
    procedure Insert(index: Integer; value: Group);
    procedure Remove(value: Group);
    procedure Clear;
    procedure RemoveAt(index: Integer);
    {$ENDREGION 'ECO generated code'}
  end;
  [UmlCollection(TypeOf(Participant))]
  IParticipantList = interface(ICollection)
    {$REGION 'ECO generated code'}
    function get_Item(index: Integer): Participant;
    procedure set_Item(index: Integer; Value: Participant);
    property Item[index: Integer]: Participant read get_Item write set_Item; default;
    function Add(value: Participant): Integer;
    function Contains(value: Participant): Boolean;
    function IndexOf(value: Participant): Integer;
    procedure Insert(index: Integer; value: Participant);
    procedure Remove(value: Participant);
    procedure Clear;
    procedure RemoveAt(index: Integer);
    {$ENDREGION 'ECO generated code'}
  end;
  
  [UmlElement(Id='001be1c3-c0e6-4a5f-b7ef-ec447e28a429')]
  Participant = class(System.Object, ILoopBack)
    {$REGION 'ECO generated code'}
  public
  type
    Eco_LoopbackIndices = class
    public
    const
      Eco_FirstMember = 0;
    const
      Eco_MemberCount = (Eco_FirstMember + 5);
    const
      Location = Eco_FirstMember;
    const
      Name = (Eco_LoopbackIndices.Location + 1);
    const
      groups = (Eco_LoopbackIndices.Name + 1);
    const
      meetings = (Eco_LoopbackIndices.groups + 1);
    const
      Participancy = (Eco_LoopbackIndices.meetings + 1);
    end;

    ParticipantListAdapter = class(ObjectListAdapter, IParticipantList)
    public
      constructor Create(source: IList);
      function get_Item(index: Integer): Participant;
      procedure set_Item(index: Integer; Value: Participant);
      property Item[index: Integer]: Participant read get_Item write set_Item; default;
      function Add(value: Participant): Integer;
      function Contains(value: Participant): Boolean;
      function IndexOf(value: Participant): Integer;
      procedure Insert(index: Integer; value: Participant);
      procedure Remove(value: Participant);
    end;
    
  strict protected
    eco_Content: IContent;
  strict private
    function IObjectProvider.AsIObject = IObjectProvider_AsIObject;
    function IObjectProvider_AsIObject: IObject;
  public
    function AsIObject: IObjectInstance;
    procedure set_MemberByIndex(index: Integer; value: System.Object); virtual;
    function get_MemberByIndex(index: Integer): System.Object; virtual;
  strict protected
    procedure Deinitialize(serviceProvider: IEcoServiceProvider);
    procedure Initialize(serviceProvider: IEcoServiceProvider);
  public
    constructor Create(content: IContent); overload;
    {$ENDREGION 'ECO generated code'}
    constructor Create(serviceProvider: IEcoServiceProvider); overload;
    function get_Location: string;
    procedure set_Location(Value: string);
    [UmlElement(Id='071509cc-b608-4b77-a2bb-4a647f486837', Index=Eco_LoopbackIndices.Location)]
    [UmlMetaAttribute('initialValue', 'Headquarter')]
    property Location: string read get_Location write set_Location;
    function get_Name: string;
    procedure set_Name(Value: string);
    [UmlElement(Id='6b8f516a-a3e7-4b39-a6f3-7028f36d4856', Index=Eco_LoopbackIndices.Name)]
    [UmlMetaAttribute('initialValue', 'default')]
    property Name: string read get_Name write set_Name;
    function get_groups: IGroupList;
    [UmlElement('AssociationEnd', Index=Eco_LoopbackIndices.groups, Id='21185476-' +
    'a0e6-44de-99be-8d9616efdd96')]
    [UmlMetaAttribute('association', TypeOf(CoreClasses.Membership), Index=0)]
    [UmlMetaAttribute('multiplicity', '0..*')]
    property groups: IGroupList read get_groups;
    function get_meetings: IMeetingList;
    [UmlElement('AssociationEnd', Index=Eco_LoopbackIndices.meetings, Id='9150a87' +
    'a-ed79-49ad-abb9-5287896ab609')]
    [UmlMetaAttribute('association', TypeOf(CoreClasses.Participancy), Index=0)]
    [UmlMetaAttribute('multiplicity', '0..*')]
    property meetings: IMeetingList read get_meetings;
    function get_Participancy: IParticipancyList;
    [LinkRole('9150a87a-ed79-49ad-abb9-5287896ab609')]
    property Participancy: IParticipancyList read get_Participancy;
  end;
  
  [UmlElement(Id='7add5d17-24d9-45a5-af23-a60a4b8f623c')]
  [UmlTaggedValue('Eco.TableMapping', 'Parent')]
  Person = class(Participant)
  public
  type
    PersonListAdapter = class(ObjectListAdapter, IPersonList)
    public
      constructor Create(source: IList);
      function get_Item(index: Integer): Person;
      procedure set_Item(index: Integer; Value: Person);
      property Item[index: Integer]: Person read get_Item write set_Item; default;
      function Add(value: Person): Integer;
      function Contains(value: Person): Boolean;
      function IndexOf(value: Person): Integer;
      procedure Insert(index: Integer; value: Person);
      procedure Remove(value: Person);
    end;
    {$REGION 'ECO generated code'}
  public
  type
    Eco_LoopbackIndices = class
    public
    const
      Eco_FirstMember = Participant.Eco_LoopbackIndices.Eco_MemberCount;
    const
      Eco_MemberCount = (Eco_FirstMember + 2);
    const
      Address = Eco_FirstMember;
    const
      ownedResources = (Eco_LoopbackIndices.Address + 1);
    end;
    
    constructor Create(content: IContent); overload;
    {$ENDREGION 'ECO generated code'}
    constructor Create(serviceProvider: IEcoServiceProvider); overload;
    function get_Address: string;
    procedure set_Address(Value: string);
    [UmlElement(Id='2653f782-dd96-4dea-aef2-344c84993830', Index=Eco_LoopbackIndices.Address)]
    [UmlMetaAttribute('initialValue', 'default')]
    property Address: string read get_Address write set_Address;
    function get_ownedResources: IResourceList;
    [UmlElement('AssociationEnd', Index=Eco_LoopbackIndices.ownedResources, Id='9' +
    'c68567f-2503-42d2-bdb3-5dfcf961ea66')]
    [UmlMetaAttribute('association', TypeOf(CoreClasses.Ownership), Index=0)]
    [UmlMetaAttribute('multiplicity', '0..*')]
    property ownedResources: IResourceList read get_ownedResources;
  end;
  
  [UmlElement(Id='2f380891-0905-418a-b563-ebfc0509063d')]
  [UmlTaggedValue('Eco.TableMapping', 'Parent')]
  Resource = class(Participant)
  public
  type
    ResourceListAdapter = class(ObjectListAdapter, IResourceList)
    public
      constructor Create(source: IList);
      function get_Item(index: Integer): Resource;
      procedure set_Item(index: Integer; Value: Resource);
      property Item[index: Integer]: Resource read get_Item write set_Item; default;
      function Add(value: Resource): Integer;
      function Contains(value: Resource): Boolean;
      function IndexOf(value: Resource): Integer;
      procedure Insert(index: Integer; value: Resource);
      procedure Remove(value: Resource);
    end;
    {$REGION 'ECO generated code'}
  public
  type
    Eco_LoopbackIndices = class
    public
    const
      Eco_FirstMember = Participant.Eco_LoopbackIndices.Eco_MemberCount;
    const
      Eco_MemberCount = (Eco_FirstMember + 2);
    const
      Kind = Eco_FirstMember;
    const
      owner = (Eco_LoopbackIndices.Kind + 1);
    end;
    
    constructor Create(content: IContent); overload;
    {$ENDREGION 'ECO generated code'}
    constructor Create(serviceProvider: IEcoServiceProvider); overload;
    function get_Kind: string;
    procedure set_Kind(Value: string);
    [UmlElement(Id='74fa5b63-82f0-45ab-8c8d-ae2cd42d276f', Index=Eco_LoopbackIndices.Kind)]
    property Kind: string read get_Kind write set_Kind;
    function get_owner: Person;
    procedure set_owner(Value: Person);
    [UmlElement('AssociationEnd', Index=Eco_LoopbackIndices.owner, Id='f6f4febb-d' +
    '615-4d7a-a0b6-ebcd8358e9b9')]
    [UmlMetaAttribute('association', TypeOf(CoreClasses.Ownership), Index=1)]
    [UmlMetaAttribute('multiplicity', '0..1')]
    property owner: Person read get_owner write set_owner;
  end;
  
  [UmlElement(Id='0a4ed39d-086e-4d18-b739-0f1cc89d28da')]
  [UmlTaggedValue('Eco.TableMapping', 'Parent')]
  Group = class(Participant)
  public
  type
    GroupListAdapter = class(ObjectListAdapter, IGroupList)
    public
      constructor Create(source: IList);
      function get_Item(index: Integer): Group;
      procedure set_Item(index: Integer; Value: Group);
      property Item[index: Integer]: Group read get_Item write set_Item; default;
      function Add(value: Group): Integer;
      function Contains(value: Group): Boolean;
      function IndexOf(value: Group): Integer;
      procedure Insert(index: Integer; value: Group);
      procedure Remove(value: Group);
    end;
    {$REGION 'ECO generated code'}
  public
  type
    Eco_LoopbackIndices = class
    public
    const
      Eco_FirstMember = Participant.Eco_LoopbackIndices.Eco_MemberCount;
    const
      Eco_MemberCount = (Eco_FirstMember + 1);
    const
      members = Eco_FirstMember;
    end;
    
    constructor Create(content: IContent); overload;
    {$ENDREGION 'ECO generated code'}
    constructor Create(serviceProvider: IEcoServiceProvider); overload;
    function get_members: IParticipantList;
    [UmlElement('AssociationEnd', Index=Eco_LoopbackIndices.members, Id='9f2e98c2' +
    '-d8ed-47e4-b3e6-336eaac7ae4d')]
    [UmlMetaAttribute('association', TypeOf(CoreClasses.Membership), Index=1)]
    [UmlMetaAttribute('multiplicity', '0..*')]
    property members: IParticipantList read get_members;
  end;
  [UmlCollection(TypeOf(Participancy))]
  IParticipancyList = interface(ICollection)
    {$REGION 'ECO generated code'}
    function get_Item(index: Integer): Participancy;
    procedure set_Item(index: Integer; Value: Participancy);
    property Item[index: Integer]: Participancy read get_Item write set_Item; default;
    function Add(value: Participancy): Integer;
    function Contains(value: Participancy): Boolean;
    function IndexOf(value: Participancy): Integer;
    procedure Insert(index: Integer; value: Participancy);
    procedure Remove(value: Participancy);
    procedure Clear;
    procedure RemoveAt(index: Integer);
    {$ENDREGION 'ECO generated code'}
  end;
  
  [UmlElement(Id='a0d4884b-9074-4978-9ae8-0c60e4d574a3')]
  [UmlMetaAttribute('association', TypeOf(CoreClasses.Participancy))]
  Participancy = class(System.Object, ILoopBack)
    {$REGION 'ECO generated code'}
  public
  type
    Eco_LoopbackIndices = class
    public
    const
      Eco_FirstMember = 0;
    const
      Eco_MemberCount = (Eco_FirstMember + 3);
    const
      Confirmed = Eco_FirstMember;
    const
      participants = (Eco_LoopbackIndices.Confirmed + 1);
    const
      meetings = (Eco_LoopbackIndices.participants + 1);
    end;

    ParticipancyListAdapter = class(ObjectListAdapter, IParticipancyList)
    public
      constructor Create(source: IList);
      function get_Item(index: Integer): Participancy;
      procedure set_Item(index: Integer; Value: Participancy);
      property Item[index: Integer]: Participancy read get_Item write set_Item; default;
      function Add(value: Participancy): Integer;
      function Contains(value: Participancy): Boolean;
      function IndexOf(value: Participancy): Integer;
      procedure Insert(index: Integer; value: Participancy);
      procedure Remove(value: Participancy);
    end;
    
  strict protected
    eco_Content: IContent;
  strict private
    function IObjectProvider.AsIObject = IObjectProvider_AsIObject;
    function IObjectProvider_AsIObject: IObject;
  public
    function AsIObject: IObjectInstance;
    procedure set_MemberByIndex(index: Integer; value: System.Object); virtual;
    function get_MemberByIndex(index: Integer): System.Object; virtual;
  strict protected
    procedure Deinitialize(serviceProvider: IEcoServiceProvider);
    procedure Initialize(serviceProvider: IEcoServiceProvider);
  public
    constructor Create(content: IContent); overload;
    {$ENDREGION 'ECO generated code'}
    constructor Create(serviceProvider: IEcoServiceProvider); overload;
    function get_Confirmed: Boolean;
    procedure set_Confirmed(Value: Boolean);
    [UmlElement(Id='bae96888-4d0c-4d1b-b81c-df8c4c5c5e2d', Index=Eco_LoopbackIndices.Confirmed)]
    [UmlMetaAttribute('initialValue', 'false')]
    property Confirmed: Boolean read get_Confirmed write set_Confirmed;
    function get_participants: CoreClassesUnit.Participant;
    [InnerLink('22b26c13-be6e-4951-a135-495440bd5b84')]
    property participants: CoreClassesUnit.Participant read get_participants;
    function get_meetings: CoreClassesUnit.Meeting;
    [InnerLink('9150a87a-ed79-49ad-abb9-5287896ab609')]
    property meetings: CoreClassesUnit.Meeting read get_meetings;
  end;
  
  [assembly: RuntimeRequiredAttribute(TypeOf(CoreClasses))]

implementation

constructor Resource.Create(content: IContent);
begin
  inherited Create(content);
end;

{$ENDREGION 'ECO generated code'}

constructor Resource.Create(serviceProvider: IEcoServiceProvider);
begin
  inherited Create(serviceProvider);
  try
    // User code here
  except
    on System.Exception do
    begin
      Self.Deinitialize(serviceProvider);
      raise;
    end;
  end;
end;

function Resource.get_Kind: string;
begin
  Result := (string(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Kind)));
end;

procedure Resource.set_Kind(Value: string);
begin
  Self.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Kind, (System.Object(Value)));
end;

function Resource.get_owner: Person;
begin
  Result := (CoreClassesUnit.Person(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.owner)));
end;

procedure Resource.set_owner(Value: Person);
begin
  Self.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.owner, (System.Object(Value)));
end;

constructor Resource.ResourceListAdapter.Create(source: IList);
begin
  inherited Create(source);
end;

function Resource.ResourceListAdapter.get_Item(index: Integer): Resource;
begin
  Result := (Resource(inherited Adaptee[index]));
end;

procedure Resource.ResourceListAdapter.set_Item(index: Integer; Value: Resource);
begin
  inherited Adaptee[index] := value;
end;

function Resource.ResourceListAdapter.Add(value: Resource): Integer;
begin
  Result := Self.Adaptee.Add(value);
end;

function Resource.ResourceListAdapter.Contains(value: Resource): Boolean;
begin
  Result := Self.Adaptee.Contains(value);
end;

function Resource.ResourceListAdapter.IndexOf(value: Resource): Integer;
begin
  Result := Self.Adaptee.IndexOf(value);
end;

procedure Resource.ResourceListAdapter.Insert(index: Integer; value: Resource);
begin
  Self.Adaptee.Insert(index, value);
end;

procedure Resource.ResourceListAdapter.Remove(value: Resource);
begin
  Self.Adaptee.Remove(value);
end;

constructor Person.Create(content: IContent);
begin
  inherited Create(content);
end;

{$ENDREGION 'ECO generated code'}

constructor Person.Create(serviceProvider: IEcoServiceProvider);
begin
  inherited Create(serviceProvider);
  try
    // User code here
  except
    on System.Exception do
    begin
      Self.Deinitialize(serviceProvider);
      raise;
    end;
  end;
end;

function Person.get_Address: string;
begin
  Result := (string(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Address)));
end;

procedure Person.set_Address(Value: string);
begin
  Self.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Address, (System.Object(Value)));
end;

function Person.get_ownedResources: IResourceList;
begin
  Result := CoreClassesUnit.Resource.ResourceListAdapter.Create((IList(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.ownedResources))));
end;

constructor Person.PersonListAdapter.Create(source: IList);
begin
  inherited Create(source);
end;

function Person.PersonListAdapter.get_Item(index: Integer): Person;
begin
  Result := (Person(inherited Adaptee[index]));
end;

procedure Person.PersonListAdapter.set_Item(index: Integer; Value: Person);
begin
  inherited Adaptee[index] := value;
end;

function Person.PersonListAdapter.Add(value: Person): Integer;
begin
  Result := Self.Adaptee.Add(value);
end;

function Person.PersonListAdapter.Contains(value: Person): Boolean;
begin
  Result := Self.Adaptee.Contains(value);
end;

function Person.PersonListAdapter.IndexOf(value: Person): Integer;
begin
  Result := Self.Adaptee.IndexOf(value);
end;

procedure Person.PersonListAdapter.Insert(index: Integer; value: Person);
begin
  Self.Adaptee.Insert(index, value);
end;

procedure Person.PersonListAdapter.Remove(value: Person);
begin
  Self.Adaptee.Remove(value);
end;

function Meeting.IObjectProvider_AsIObject: IObject;
begin
  Result := Self.eco_Content.AsIObject;
end;

function Meeting.AsIObject: IObjectInstance;
begin
  Result := Self.eco_Content.AsIObject;
end;

procedure Meeting.set_MemberByIndex(index: Integer; value: System.Object);
begin
  raise System.IndexOutOfRangeException.Create;
end;

function Meeting.get_MemberByIndex(index: Integer): System.Object;
begin
  raise System.IndexOutOfRangeException.Create;
end;

procedure Meeting.Deinitialize(serviceProvider: IEcoServiceProvider);
var
  factory: IInternalObjectContentFactory;
begin
  if (Self.eco_Content <> nil) then
  begin
    factory := (IInternalObjectContentFactory(serviceProvider.GetEcoService(TypeOf(IInternalObjectContentFactory))));
    factory.CreateContentFailed(Self.eco_Content, Self);
    Self.eco_Content := nil;
  end;
end;

procedure Meeting.Initialize(serviceProvider: IEcoServiceProvider);
var
  factory: IInternalObjectContentFactory;
begin
  if (Self.eco_Content = nil) then
  begin
    factory := (IInternalObjectContentFactory(serviceProvider.GetEcoService(TypeOf(IInternalObjectContentFactory))));
    Self.eco_Content := factory.CreateContent(Self);
    Self.eco_Content.LoopbackValid;
  end;
end;

constructor Meeting.Create(content: IContent);
begin
  inherited Create;
  Self.eco_Content := content;
  content.AssertLoopbackUnassigned;
end;

{$ENDREGION 'ECO generated code'}

constructor Meeting.Create(serviceProvider: IEcoServiceProvider);
begin
  inherited Create;
  Self.Initialize(serviceProvider);
  try
    // User code here
  except
    on System.Exception do
    begin
      Self.Deinitialize(serviceProvider);
      raise;
    end;
  end;
end;

function Meeting.get_EndTime: System.DateTime;
begin
  Result := (System.DateTime(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.EndTime)));
end;

function Meeting.get_Duration: Integer;
begin
  Result := (Integer(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Duration)));
end;

procedure Meeting.set_Duration(Value: Integer);
begin
  Self.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Duration, (System.Object(Value)));
end;

function Meeting.get_Subject: string;
begin
  Result := (string(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Subject)));
end;

procedure Meeting.set_Subject(Value: string);
begin
  Self.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Subject, (System.Object(Value)));
end;

function Meeting.get_Time: System.DateTime;
begin
  Result := (System.DateTime(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Time)));
end;

procedure Meeting.set_Time(Value: System.DateTime);
begin
  Self.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Time, (System.Object(Value)));
end;

function Meeting.get_participants: IParticipantList;
begin
  Result := CoreClassesUnit.Participant.ParticipantListAdapter.Create((IList(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.participants))));
end;

function Meeting.get_Participancy: IParticipancyList;
begin
  Result := CoreClassesUnit.Participancy.ParticipancyListAdapter.Create((IList(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Participancy))));
end;

function Meeting.get_confirmedParticipants: IParticipantList;
begin
  Result := CoreClassesUnit.Participant.ParticipantListAdapter.Create((IList(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.confirmedParticipants))));
end;

procedure Meeting.CancelMeeting;
begin
end;

procedure Meeting.RemindParticipants;
begin
end;

function Meeting.EndTimeDeriveAndSubscribe(ReevaluateSubscriber: Borland.Eco.Subscription.ISubscriber; 
  ResubscribeSubscriber: Borland.Eco.Subscription.ISubscriber): System.Object;
begin
end;

constructor Meeting.MeetingListAdapter.Create(source: IList);
begin
  inherited Create(source);
end;

function Meeting.MeetingListAdapter.get_Item(index: Integer): Meeting;
begin
  Result := (Meeting(inherited Adaptee[index]));
end;

procedure Meeting.MeetingListAdapter.set_Item(index: Integer; Value: Meeting);
begin
  inherited Adaptee[index] := value;
end;

function Meeting.MeetingListAdapter.Add(value: Meeting): Integer;
begin
  Result := Self.Adaptee.Add(value);
end;

function Meeting.MeetingListAdapter.Contains(value: Meeting): Boolean;
begin
  Result := Self.Adaptee.Contains(value);
end;

function Meeting.MeetingListAdapter.IndexOf(value: Meeting): Integer;
begin
  Result := Self.Adaptee.IndexOf(value);
end;

procedure Meeting.MeetingListAdapter.Insert(index: Integer; value: Meeting);
begin
  Self.Adaptee.Insert(index, value);
end;

procedure Meeting.MeetingListAdapter.Remove(value: Meeting);
begin
  Self.Adaptee.Remove(value);
end;

constructor Group.Create(content: IContent);
begin
  inherited Create(content);
end;

{$ENDREGION 'ECO generated code'}

constructor Group.Create(serviceProvider: IEcoServiceProvider);
begin
  inherited Create(serviceProvider);
  try
    // User code here
  except
    on System.Exception do
    begin
      Self.Deinitialize(serviceProvider);
      raise;
    end;
  end;
end;

function Group.get_members: IParticipantList;
begin
  Result := CoreClassesUnit.Participant.ParticipantListAdapter.Create((IList(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.members))));
end;

constructor Group.GroupListAdapter.Create(source: IList);
begin
  inherited Create(source);
end;

function Group.GroupListAdapter.get_Item(index: Integer): Group;
begin
  Result := (Group(inherited Adaptee[index]));
end;

procedure Group.GroupListAdapter.set_Item(index: Integer; Value: Group);
begin
  inherited Adaptee[index] := value;
end;

function Group.GroupListAdapter.Add(value: Group): Integer;
begin
  Result := Self.Adaptee.Add(value);
end;

function Group.GroupListAdapter.Contains(value: Group): Boolean;
begin
  Result := Self.Adaptee.Contains(value);
end;

function Group.GroupListAdapter.IndexOf(value: Group): Integer;
begin
  Result := Self.Adaptee.IndexOf(value);
end;

procedure Group.GroupListAdapter.Insert(index: Integer; value: Group);
begin
  Self.Adaptee.Insert(index, value);
end;

procedure Group.GroupListAdapter.Remove(value: Group);
begin
  Self.Adaptee.Remove(value);
end;

function Participant.IObjectProvider_AsIObject: IObject;
begin
  Result := Self.eco_Content.AsIObject;
end;

function Participant.AsIObject: IObjectInstance;
begin
  Result := Self.eco_Content.AsIObject;
end;

procedure Participant.set_MemberByIndex(index: Integer; value: System.Object);
begin
  raise System.IndexOutOfRangeException.Create;
end;

function Participant.get_MemberByIndex(index: Integer): System.Object;
begin
  raise System.IndexOutOfRangeException.Create;
end;

procedure Participant.Deinitialize(serviceProvider: IEcoServiceProvider);
var
  factory: IInternalObjectContentFactory;
begin
  if (Self.eco_Content <> nil) then
  begin
    factory := (IInternalObjectContentFactory(serviceProvider.GetEcoService(TypeOf(IInternalObjectContentFactory))));
    factory.CreateContentFailed(Self.eco_Content, Self);
    Self.eco_Content := nil;
  end;
end;

procedure Participant.Initialize(serviceProvider: IEcoServiceProvider);
var
  factory: IInternalObjectContentFactory;
begin
  if (Self.eco_Content = nil) then
  begin
    factory := (IInternalObjectContentFactory(serviceProvider.GetEcoService(TypeOf(IInternalObjectContentFactory))));
    Self.eco_Content := factory.CreateContent(Self);
    Self.eco_Content.LoopbackValid;
  end;
end;

constructor Participant.Create(content: IContent);
begin
  inherited Create;
  Self.eco_Content := content;
  content.AssertLoopbackUnassigned;
end;

{$ENDREGION 'ECO generated code'}

constructor Participant.Create(serviceProvider: IEcoServiceProvider);
begin
  inherited Create;
  Self.Initialize(serviceProvider);
  try
    // User code here
  except
    on System.Exception do
    begin
      Self.Deinitialize(serviceProvider);
      raise;
    end;
  end;
end;

function Participant.get_Location: string;
begin
  Result := (string(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Location)));
end;

procedure Participant.set_Location(Value: string);
begin
  Self.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Location, (System.Object(Value)));
end;

function Participant.get_Name: string;
begin
  Result := (string(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Name)));
end;

procedure Participant.set_Name(Value: string);
begin
  Self.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Name, (System.Object(Value)));
end;

function Participant.get_groups: IGroupList;
begin
  Result := CoreClassesUnit.Group.GroupListAdapter.Create((IList(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.groups))));
end;

function Participant.get_meetings: IMeetingList;
begin
  Result := CoreClassesUnit.Meeting.MeetingListAdapter.Create((IList(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.meetings))));
end;

function Participant.get_Participancy: IParticipancyList;
begin
  Result := CoreClassesUnit.Participancy.ParticipancyListAdapter.Create((IList(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Participancy))));
end;

constructor Participant.ParticipantListAdapter.Create(source: IList);
begin
  inherited Create(source);
end;

function Participant.ParticipantListAdapter.get_Item(index: Integer): Participant;
begin
  Result := (Participant(inherited Adaptee[index]));
end;

procedure Participant.ParticipantListAdapter.set_Item(index: Integer; Value: Participant);
begin
  inherited Adaptee[index] := value;
end;

function Participant.ParticipantListAdapter.Add(value: Participant): Integer;
begin
  Result := Self.Adaptee.Add(value);
end;

function Participant.ParticipantListAdapter.Contains(value: Participant): Boolean;
begin
  Result := Self.Adaptee.Contains(value);
end;

function Participant.ParticipantListAdapter.IndexOf(value: Participant): Integer;
begin
  Result := Self.Adaptee.IndexOf(value);
end;

procedure Participant.ParticipantListAdapter.Insert(index: Integer; value: Participant);
begin
  Self.Adaptee.Insert(index, value);
end;

procedure Participant.ParticipantListAdapter.Remove(value: Participant);
begin
  Self.Adaptee.Remove(value);
end;

function Participancy.IObjectProvider_AsIObject: IObject;
begin
  Result := Self.eco_Content.AsIObject;
end;

function Participancy.AsIObject: IObjectInstance;
begin
  Result := Self.eco_Content.AsIObject;
end;

procedure Participancy.set_MemberByIndex(index: Integer; value: System.Object);
begin
  raise System.IndexOutOfRangeException.Create;
end;

function Participancy.get_MemberByIndex(index: Integer): System.Object;
begin
  raise System.IndexOutOfRangeException.Create;
end;

procedure Participancy.Deinitialize(serviceProvider: IEcoServiceProvider);
var
  factory: IInternalObjectContentFactory;
begin
  if (Self.eco_Content <> nil) then
  begin
    factory := (IInternalObjectContentFactory(serviceProvider.GetEcoService(TypeOf(IInternalObjectContentFactory))));
    factory.CreateContentFailed(Self.eco_Content, Self);
    Self.eco_Content := nil;
  end;
end;

procedure Participancy.Initialize(serviceProvider: IEcoServiceProvider);
var
  factory: IInternalObjectContentFactory;
begin
  if (Self.eco_Content = nil) then
  begin
    factory := (IInternalObjectContentFactory(serviceProvider.GetEcoService(TypeOf(IInternalObjectContentFactory))));
    Self.eco_Content := factory.CreateContent(Self);
    Self.eco_Content.LoopbackValid;
  end;
end;

constructor Participancy.Create(content: IContent);
begin
  inherited Create;
  Self.eco_Content := content;
  content.AssertLoopbackUnassigned;
end;

{$ENDREGION 'ECO generated code'}

constructor Participancy.Create(serviceProvider: IEcoServiceProvider);
begin
  inherited Create;
  Self.Initialize(serviceProvider);
  try
    // User code here
  except
    on System.Exception do
    begin
      Self.Deinitialize(serviceProvider);
      raise;
    end;
  end;
end;

function Participancy.get_Confirmed: Boolean;
begin
  Result := (Boolean(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Confirmed)));
end;

procedure Participancy.set_Confirmed(Value: Boolean);
begin
  Self.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Confirmed, (System.Object(Value)));
end;

function Participancy.get_participants: CoreClassesUnit.Participant;
begin
  Result := (CoreClassesUnit.Participant(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.participants)));
end;

function Participancy.get_meetings: CoreClassesUnit.Meeting;
begin
  Result := (CoreClassesUnit.Meeting(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.meetings)));
end;

{ DerivedAssociation }


constructor Participancy.ParticipancyListAdapter.Create(source: IList);
begin
  inherited Create(source);
end;

function Participancy.ParticipancyListAdapter.get_Item(index: Integer): Participancy;
begin
  Result := (Participancy(inherited Adaptee[index]));
end;

procedure Participancy.ParticipancyListAdapter.set_Item(index: Integer; Value: Participancy);
begin
  inherited Adaptee[index] := value;
end;

function Participancy.ParticipancyListAdapter.Add(value: Participancy): Integer;
begin
  Result := Self.Adaptee.Add(value);
end;

function Participancy.ParticipancyListAdapter.Contains(value: Participancy): Boolean;
begin
  Result := Self.Adaptee.Contains(value);
end;

function Participancy.ParticipancyListAdapter.IndexOf(value: Participancy): Integer;
begin
  Result := Self.Adaptee.IndexOf(value);
end;

procedure Participancy.ParticipancyListAdapter.Insert(index: Integer; value: Participancy);
begin
  Self.Adaptee.Insert(index, value);
end;

procedure Participancy.ParticipancyListAdapter.Remove(value: Participancy);
begin
  Self.Adaptee.Remove(value);
end;

end.
